﻿using StokYonetimSistemi.DataAccess;
using StokYonetimSistemi.Entities;
using System;
using System.Collections.Generic;
using System.Linq;

namespace StokYonetimSistemi.Business
{
    public class KategoriManager
    {
        // CRUD (Create, Read, Update, Delete) Operasyonları

        public List<Kategori> TumKategorileriGetir()
        {
            using (var context = new StokYonetimDbContext())
            {
                return context.Kategoriler.ToList();
            }
        }

        public void KategoriEkle(Kategori kategori)
        {
            using (var context = new StokYonetimDbContext())
            {
                // İş Kuralı: Aynı isimde başka bir kategori olamaz.
                if (context.Kategoriler.Any(k => k.Ad.ToLower() == kategori.Ad.ToLower()))
                {
                    throw new Exception("Bu isimde bir kategori zaten mevcut!");
                }

                context.Kategoriler.Add(kategori);
                context.SaveChanges();
            }
        }

        public void KategoriGuncelle(Kategori kategori)
        {
            using (var context = new StokYonetimDbContext())
            {
                context.Entry(kategori).State = Microsoft.EntityFrameworkCore.EntityState.Modified;
                context.SaveChanges();
            }
        }

        public void KategoriSil(int id)
        {
            using (var context = new StokYonetimDbContext())
            {
                var silinecekKategori = context.Kategoriler.Find(id);
                if (silinecekKategori != null)
                {
                    context.Kategoriler.Remove(silinecekKategori);
                    context.SaveChanges();
                }
            }
        }
    }
}